% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_eval_functions.R
\name{dm.test.bt}
\alias{dm.test.bt}
\title{Diebold-Mariano Test (Bartlett kernel, normal approximation)}
\usage{
dm.test.bt(d, M = NA, Mopt = NA, cl = 0.05)
}
\arguments{
\item{d}{loss differential}

\item{M}{truncation parameter for the Bartlett kernel (if \code{M = NA}, then \code{Mopt = 2} by default)}

\item{Mopt}{option for automatic bandwidth, 1 if Lazarus et al. (2018), 2 if Newey and West (1994, default), 3 if Andrews textbook NW (\eqn{M=\lceil 0.75T^{1/3}\rceil}), 4 if CI baseline (\eqn{M=\lfloor T^{1/2}\rfloor})}

\item{cl}{confidence level (default = 0.05, i.e., 5\%)}
}
\value{
This function returns a class with the following elements
\itemize{
\item \code{rej} is a T/F value. TRUE (reject), FALSE (accept)
\item \code{stat} is a test statistic
\item \code{pval} is an associated p-value
}
}
\description{
Diebold-Mariano Test (Bartlett kernel, normal approximation). This is a two-sided test.
}
\author{
Minchul Shin
}
