% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.M.R
\name{model.M}
\alias{model.M}
\title{Function to perform an EM algorithm (“Multiple” univariate KDEs (nonparametric naive Bayes)) for a 2-component mixture where each observation i has a p-value pi, and an auxiliary feature vector vi}
\usage{
model.M(pvalues, v, alpha0, alpha1, pi0, pi1, max.it, verbose = verbose)
}
\arguments{
\item{pvalues}{Vector of gene-level p-values}

\item{v}{an auxiliary feature vector}

\item{alpha0}{Mixing proportion (prior probability) that an observation belongs to the alternative/signal component \eqn{Z = 1}
in the two-component mixture; typically \eqn{\pi_1 = 1 - \pi_0}.}

\item{alpha1}{Shape parameter of the alternative/signal p-value distribution, modeled as
\eqn{p \sim \mathrm{Beta}(\alpha_1, 1)} when \eqn{Z = 1}; values \eqn{< 1} concentrate mass near 0 (enrichment of small p-values).}

\item{pi0}{Mixing proportion (prior probability) that an observation belongs to the null/background component \eqn{Z = 0}
in the two-component mixture.}

\item{pi1}{Mixing proportion (prior probability) that an observation belongs to the alternative/signal component \eqn{Z = 1}
in the two-component mixture; typically \eqn{\pi_1 = 1 - \pi_0}.}

\item{max.it}{Maximum number of iterations for the EM algorithm.}

\item{verbose}{A logical value defining if the iteration information should be printed or not.}
}
\value{
Returns the posterior probability of association for each gene.
}
\description{
Function to perform an EM algorithm (“Multiple” univariate KDEs (nonparametric naive Bayes)) for a 2-component mixture where each observation i has a p-value pi, and an auxiliary feature vector vi
}
\keyword{internal}
