% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vallet_vc22.r
\name{vallet_vc22}
\alias{vallet_vc22}
\title{Calculate Commercial Volume (vc22) up to 7cm Diameter at Breast Height (dbh)}
\usage{
vallet_vc22(data, na_action = c("error", "omit"), output = NULL)
}
\arguments{
\item{data}{A data frame containing tree measurements. Must include the columns:
\code{species_code}, \code{dbh} (diameter at 1.30m, in cm), and \code{htot} (total height, in m).}

\item{na_action}{How to handle missing input values. \code{"error"} (default) stops if
core required values are explicitly \code{NA}. \code{"omit"} removes rows with missing core data.}

\item{output}{Optional file path where the resulting data frame should be
exported as a CSV. If NULL (default), no file is written.
Export is handled by the utility function \code{export_output()} and
failures trigger warnings without interrupting execution.}
}
\value{
The resulting data frame with the new column \code{vallet_vc22}
(Commercial Volume in \strong{m3}).
}
\description{
Computes the commercial wood volume (vc22, over bark, up to a 7 cm top-diameter)
using the Vallet polynomial model, based on dbh (cm) and htot (m).
}
\details{
The model is valid only for trees with a diameter at 1.30m (\code{dbh})
greater than or equal to 7 cm.

The polynomial formula used is:
\deqn{VC22_{dm^3} = a \cdot \frac{h_{tot}}{dbh} + (b + c \cdot dbh) \cdot \frac{\pi \cdot dbh^2 \cdot h_{tot}}{40}}

Coefficients a, b, c are species-specific and loaded from the \code{vallet_vc22.csv} file.
}
\examples{
data_test_vc22 <- data.frame(
  species_code = c("PICEA_ABIES", "FAGUS_SYLVATICA", "UNKNOWN_SPECIES", "QUERCUS_ROBUR"),
  dbh = c(19.1, 25.5, 15.9, 6.4), 
  htot = c(25, 18, 20, 22)
)

results_console <- vallet_vc22(data_test_vc22)
print(results_console)

}
