% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressKDisclosure.R
\name{default_targeting}
\alias{default_targeting}
\title{Default \code{targeting} function for SuppressKDisclosure()}
\usage{
default_targeting(
  crossTable,
  x,
  identifying = NULL,
  sensitive = NULL,
  targeting_include = NULL,
  targeting_exclude = NULL,
  ...
)
}
\arguments{
\item{crossTable}{A \code{crossTable}, possibly extended after applying
\code{mc_hierarchies}.}

\item{x}{The model matrix, \code{x}, possibly extended after applying
\code{mc_hierarchies}.}

\item{identifying}{Specification of information that an intruder may already
know. The specification is subject to the same requirements as \code{sensitive}
below. If not all variables are included, total codes for the missing
variables are derived automatically. This requires that the overall total
is included as an output row.}

\item{sensitive}{Specification of information considered unacceptable to
disclose. It may be given as a character vector of variable names, a named
list with variable names as names and specified codes as values, or a data
frame specifying variable combinations. The wildcard characters \code{*} and \verb{?},
as well as the exclusion operator \code{!}, may be used, since
\code{\link[SSBtools:WildcardGlobbing]{SSBtools::WildcardGlobbing()}} is applied.}

\item{targeting_include}{A list of two-element lists with components
\code{identifying} and \code{sensitive}. Each element defines identifying–sensitive
relations using the same specification rules as the parameters
\code{identifying} and \code{sensitive}. All specifications together, including the
main \code{identifying} and \code{sensitive} parameters, define the relations that are
examined for suppression.}

\item{targeting_exclude}{A list specified in the same way as
\code{targeting_include}. The relations defined here are ignored when examining
suppression.}

\item{...}{Unused parameters.}
}
\value{
A named \code{targeting} list. See \code{\link[=SuppressKDisclosure]{SuppressKDisclosure()}}.
}
\description{
Generates a \code{targeting} specification for use with
\code{\link[=SuppressKDisclosure]{SuppressKDisclosure()}}. The function is actually used internally by
\code{\link[=KDisclosurePrimary]{KDisclosurePrimary()}}.
}
\details{
The parameters \code{identifying} and \code{sensitive} are used to select table cells
(including hidden cells constructed via \code{mc_hierarchies}). All such cells are
represented by rows in \code{crossTable}, which may be extended due to
\code{mc_hierarchies}. Thus, rows in \code{crossTable} are selected as identifying or
sensitive.

In addition, \code{sensitive} specifies which codes within the selected rows are
regarded as sensitive.

The logic differs slightly for unspecified variables:
For \code{identifying}, unspecified variables are set to total codes.
For \code{sensitive}, all rows in \code{crossTable} matching the specified variables
are selected.

The parameters \code{identifying} and \code{sensitive} are used to construct the
\code{targeting} specification for \code{KDisclosurePrimary()}, resulting in the
elements \code{identifying}, \code{sensitive}, and \code{is_sensitive}.

When \code{targeting_include} and/or \code{targeting_exclude} are specified,
additional elements \code{include_relations} and \code{exclude_relations} are created.
}
\examples{

mm <- SSBtools::ModelMatrix(SSBtoolsData("example1"), 
     formula = ~age * eu + geo, crossTable = TRUE)
crossTable <- mm$crossTable
x <- mm$modelMatrix      

default_targeting(crossTable, x)  # just NULL 

# geo identifying and age sensitive (age sensitive variable)
a2 <- default_targeting(crossTable, x, 
                        identifying = "geo", 
                        sensitive = "age")
a1 <- default_targeting(crossTable, x, 
                        identifying = list(age = "Total", geo = "*"), 
                        sensitive = list(age = "*")) 
identical(a1, a2)
a1                         
                  
                  
# Not ok to disclose 'EU' and 'Portugal'
# But ok to disclose 'Spain' with 'EU' known
# and also ok to disclose 'Spain' in other table cells without 'EU' as marginal  
default_targeting(crossTable, x, 
                  sensitive = list(geo = c("Portugal", "EU")))
                  
# As above but now also ok to disclose 'Portugal' from 'EU' known,
# since protection only considers 'age' identifying.                   
default_targeting(crossTable, x, 
                  identifying = "age",
                  sensitive = list(geo = c("Portugal", "EU")))                 

}
