% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotHVT.R
\name{plotHVT}
\alias{plotHVT}
\title{Plot the hierarchical tessellations.}
\usage{
plotHVT(
  hvt.results,
  line.width = 0.5,
  color.vec = "black",
  centroid.size = 0.6,
  centroid.color = "black",
  child.level = 1,
  hmap.cols,
  separation_width = 7,
  layer_opacity = c(0.5, 0.75, 0.99),
  dim_size = 1000,
  plot.type = "2Dhvt",
  quant.error.hmap = NULL,
  cell_id = FALSE,
  cell_id_position = "bottom",
  cell_id_size = 2.6,
  centroids = TRUE
)
}
\arguments{
\item{hvt.results}{(1D/2DProj/2Dhvt/2Dheatmap/surface_plot) List. A list containing the output of \code{trainHVT} function
which has the details of the tessellations to be plotted.}

\item{line.width}{(2Dhvt/2Dheatmap) Numeric Vector. A vector indicating the line widths of the
tessellation boundaries for each level.}

\item{color.vec}{(2Dhvt/2Dheatmap) Vector. A vector indicating the colors of the boundaries of
the tessellations at each level.}

\item{centroid.size}{(2Dhvt/2Dheatmap) Numeric Vector. A vector indicating the size of centroids
for each level.}

\item{centroid.color}{(2Dhvt/2Dheatmap) Numeric Vector. A vector indicating the color of centroids
for each level.}

\item{child.level}{(2Dheatmap/surface_plot) Numeric. Indicating the level for which the plot should
be displayed}

\item{hmap.cols}{(2Dheatmap/surface_plot) Numeric or Character. The column number or column name from
the dataset indicating the variables for which the heat map is to be plotted.}

\item{separation_width}{(surface_plot) Numeric. An integer indicating the width between hierarchical levels in surface plot}

\item{layer_opacity}{(surface_plot) Numeric. A vector indicating the opacity of each hierarchical levels in surface plot}

\item{dim_size}{(surface_plot) Numeric. An integer controls the resolution or granularity of the 3D surface grid}

\item{plot.type}{Character. An option to indicate which type of plot should be generated. Accepted entries are 
'1D','2Dproj','2Dhvt','2Dheatmap'and 'surface_plot'. Default value is '2Dhvt'.}

\item{quant.error.hmap}{(2Dheatmap) Numeric. A number representing the quantization error threshold to be highlighted in the heatmap. 
When a value is provided, it will emphasize cells with quantization errors equal or less than the specified threshold,
indicating that these cells cannot be further subdivided in the next depth layer. The default value is NULL,
meaning all cells will be colored in the heatmap across various depths.}

\item{cell_id}{(2Dhvt/2Dheatmap) Logical. A logical indicating whether the cell IDs should be displayed. Default is FALSE}

\item{cell_id_position}{(2Dhvt/2Dheatmap) Character. A character indicating the position of the cell IDs. Accepted entries are 'top' , 
'bottom', 'left', 'right', and 'center'. Default is 'bottom'}

\item{cell_id_size}{(2Dhvt/2Dheatmap) Numeric. A numeric vector indicating the size of the cell IDs. Default is 2.6}

\item{centroids}{(2Dhvt/2Dheatmap) Logical. A logical indicating whether the centroid points should be displayed. Default value is TRUE.}
}
\value{
plot object containing the visualizations of reduced dimension(1D/2D) for the given dataset.
}
\description{
This is the main plotting function to construct hierarchical voronoi tessellations in 1D,2D or
Interactive surface plot.
}
\examples{
data("EuStockMarkets")
hvt.results <- trainHVT(EuStockMarkets, n_cells = 60, depth = 1, quant.err = 0.1, 
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method="kmeans")
                       
#change the 'plot.type' argument to '2Dproj' or '2DHVT' to visualize respective plots.                      
plotHVT(hvt.results, plot.type='1D')

#change the 'plot.type' argument to 'surface_plot' to visualize the Interactive surface plot                   
plotHVT(hvt.results,child.level = 1, 
hmap.cols = "DAX", plot.type = '2Dheatmap')
}
\seealso{
\code{\link{trainHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>, Sangeet Moy Das <sangeet.das@mu-sigma.com>, Vishwavani <vishwavani@mu-sigma.com>
}
\keyword{Tessellation_and_Heatmap}
