% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/my_functions.R
\name{ptf_construction}
\alias{ptf_construction}
\title{Function to compute portfolio values}
\usage{
ptf_construction(
  data,
  FT,
  ov,
  LR_cp_measure,
  ptf = c("M", "C_M", "EDC", "C_EDC")
)
}
\arguments{
\item{data}{A (T x N) matrix or data.frame containing the N time series over period T}

\item{FT}{Window size.}

\item{ov}{Overlap.}

\item{LR_cp_measure}{object of class LR_cp (only for "C_M" and "C_EDC" asset allocation strategies)}

\item{ptf}{Type of portfolio to be computed. Asset allocation strategies available are:
"M" is the Markowitz portfolio, "C_M" is the combined Markowitz portfolio,
"EDC" uses the extreme downside correlation and "C_EDC" is the combined  extreme downside correlation portfolio}
}
\value{
An object of class "ptf_construction" is a list containing the following components for all the time windows considered:
 \describe{
  \item{ptf oos value}{a vector of out of sample returns.}
  \item{weigths}{portfolio weights.}
  }
}
\description{
Function to compute portfolio values
}
