% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3summary.R
\name{summary}
\alias{summary}
\alias{summary.LCA}
\alias{summary.LPA}
\alias{summary.LTA}
\alias{summary.LCPA}
\alias{summary.sim.LCA}
\alias{summary.sim.LPA}
\alias{summary.sim.LTA}
\alias{summary.fit.index}
\alias{summary.compare.model}
\alias{summary.SE}
\title{S3 Methods: summary}
\usage{
\method{summary}{LCA}(object, digits = 4, I.max = 5, ...)

\method{summary}{LPA}(object, digits = 4, I.max = 5, ...)

\method{summary}{LTA}(object, digits = 4, I.max = 5, ...)

\method{summary}{LCPA}(object, digits = 4, I.max = 5, ...)

\method{summary}{sim.LCA}(object, digits = 4, I.max = 5, ...)

\method{summary}{sim.LPA}(object, digits = 4, I.max = 5, ...)

\method{summary}{sim.LTA}(object, digits = 4, I.max = 5, L.max = 5, ...)

\method{summary}{fit.index}(object, digits = 4, ...)

\method{summary}{compare.model}(object, digits = 4, ...)

\method{summary}{SE}(object, ...)
}
\arguments{
\item{object}{An object of one of the following classes:
\itemize{
\item Model objects: \code{\link[LCPA]{LCA}}, \code{\link[LCPA]{LPA}},
\code{\link[LCPA]{LCPA}}, \code{\link[LCPA]{LTA}}
\item Simulation objects: \code{\link[LCPA]{sim.LCA}}, \code{\link[LCPA]{sim.LPA}},
\code{\link[LCPA]{sim.LTA}}
\item Fit/comparison objects: \code{\link[LCPA]{get.fit.index}}, \code{\link[LCPA]{compare.model}}
\item Standard error objects: \code{\link[LCPA]{get.SE}}
}}

\item{digits}{Number of decimal places for numeric output (default: 4). Applied universally across all methods.}

\item{I.max}{Maximum number of variables/items to display (\code{LCA}, \code{LPA}, \code{sim.LCA}, \code{sim.LPA}, \code{sim.LTA},
\code{LCPA}, \code{LTA}, and \code{compare.model} only; default: 5). Controls verbosity for high-dimensional outputs.}

\item{...}{Additional arguments passed to or from other methods (currently ignored).}

\item{L.max}{Maximum number of latent classes/profiles to display before truncation (\code{sim.LTA} only; default: 5).
Useful when models have many latent groups. Ignored for other classes.}
}
\value{
Invisibly returns a structured list containing summary components.
The exact structure depends on the class of \code{object}. All returned objects carry an appropriate
S3 class (e.g., \code{summary.LCA}, \code{summary.LPA}) for use with corresponding \code{print} methods.
}
\description{
Generates structured, comprehensive summaries of objects produced by the \code{LCPA} package.
This generic function dispatches to class-specific methods that extract and organize key information
including model configurations, fit statistics, parameter estimates, simulation truths, and diagnostics.
Designed for programmatic access and downstream reporting.
}
\details{
Each method returns a named list with class-specific components optimized for structured access:

\describe{
\item{\strong{\code{LCA}}}{Returns a \code{summary.LCA} object with components:
\describe{
\item{\code{call}}{Original function call.}
\item{\code{model.config}}{List: \code{latent_classes}, \code{method}.}
\item{\code{data.info}}{List: \code{N}, \code{I}, \code{poly.value}, \code{uniform_categories}.}
\item{\code{fit.stats}}{List: \code{LogLik}, \code{AIC}, \code{BIC}, \code{entropy}, \code{npar}.}
\item{\code{class.probs}}{Data frame: \code{Class}, \code{Count}, \code{Proportion}.}
\item{\code{item.probs}}{List of matrices (first \code{I.max} items) with conditional probabilities per class/category.}
\item{\code{convergence}}{List: algorithm, iterations, tolerance, loglik change, hardware (if applicable).}
\item{\code{replication}}{List: \code{nrep}, \code{best_BIC} (if multiple replications performed).}
\item{\code{digits}, \code{I.max.shown}, \code{total.items}}{Metadata for printing/formatting.}
}}

\item{\strong{\code{LPA}}}{Returns a \code{summary.LPA} object with components:
\describe{
\item{\code{call}}{Original function call.}
\item{\code{model.config}}{List: \code{latent_profiles}, \code{constraint}, \code{cov_structure}, \code{method}.}
\item{\code{data.info}}{List: \code{N}, \code{I}, \code{distribution}.}
\item{\code{fit.stats}}{List: \code{LogLik}, \code{AIC}, \code{BIC}, \code{entropy}, \code{npar}.}
\item{\code{class.probs}}{Data frame: \code{Profile}, \code{Count}, \code{Proportion}.}
\item{\code{class.means}}{Matrix (first \code{I.max} variables) of profile-specific means.}
\item{\code{convergence}}{List: algorithm, iterations, tolerance, loglik change, hardware (if applicable).}
\item{\code{replication}}{List: \code{nrep}, \code{best_BIC} (if multiple replications performed).}
\item{\code{digits}, \code{I.max.shown}, \code{total.vars}}{Metadata for printing/formatting.}
}}

\item{\strong{\code{LCPA}}}{Returns a \code{summary.LCPA} object with components:
\describe{
\item{\code{call}}{Original function call.}
\item{\code{model.config}}{List: \code{latent_classes}, \code{model_type}, \code{reference_class},
\code{covariates_mode}, \code{CEP_handling}.}
\item{\code{data.info}}{List: \code{sample_size}, \code{variables}.}
\item{\code{fit.stats}}{List: \code{LogLik}, \code{AIC}, \code{BIC}, \code{npar}.}
\item{\code{class.probs}}{Data frame: \code{Class}, \code{Probability}, \code{Proportion}, \code{Frequency}.}
\item{\code{coefficients}}{Data frame: regression coefficients for non-reference classes (Estimate, Std_Error, z_value, p_value, 95\% CI).}
\item{\code{reference_class}}{Integer: reference class for multinomial logit.}
\item{\code{convergence}}{List: \code{iterations}, \code{coveraged}, \code{converg_note}.}
\item{\code{digits}, \code{I.max.shown}, \code{total.vars}, \code{has.covariates}}{Metadata for printing/formatting.}
}}

\item{\strong{\code{LTA}}}{Returns a \code{summary.LTA} object with components:
\describe{
\item{\code{call}}{Original function call.}
\item{\code{model.config}}{List: \code{time_points}, \code{latent_classes}, \code{model_type},
\code{reference_class}, \code{covariates_mode}, \code{CEP_handling}, \code{transition_mode}.}
\item{\code{data.info}}{List: \code{sample_size}, \code{variables}, \code{time_points}.}
\item{\code{fit.stats}}{List: \code{LogLik}, \code{AIC}, \code{BIC}, \code{npar}.}
\item{\code{class.probs}}{List of data frames (per time point): \code{Class}, \code{Probability}, \code{Proportion}, \code{Frequency}.}
\item{\code{initial_model}}{List: \code{coefficients} (data frame), \code{covariate_names}, \code{reference_class}.}
\item{\code{transition_models}}{Named list of data frames: transition coefficients per time interval (From_Class, To_Class, Estimate, Std_Error, etc.).}
\item{\code{reference_class}}{Integer: reference destination class for transitions.}
\item{\code{convergence}}{List: \code{iterations}, \code{coveraged}, \code{converg_note}.}
\item{\code{digits}, \code{I.max.shown}, \code{total.vars}, \code{covariates.timeCross}}{Metadata for printing/formatting.}
}}

\item{\strong{\code{sim.LCA}}}{Returns a \code{summary.sim.LCA} object with components:
\describe{
\item{\code{call}}{Original simulation call.}
\item{\code{config}}{List: \code{N}, \code{I}, \code{L}, \code{poly.value}, \code{uniform_categories}, \code{IQ}, \code{distribution}.}
\item{\code{class.probs}}{Data frame: \code{Class}, \code{Probability}, \code{Frequency}.}
\item{\code{item.probs}}{List of matrices (first \code{I.max} items) with true conditional probabilities per class/category.}
\item{\code{digits}, \code{I.max.shown}, \code{total.vars}}{Metadata for printing/formatting.}
}}

\item{\strong{\code{sim.LPA}}}{Returns a \code{summary.sim.LPA} object with components:
\describe{
\item{\code{call}}{Original simulation call.}
\item{\code{config}}{List: \code{N}, \code{I}, \code{L}, \code{constraint}, \code{constraint_desc}, \code{distribution}.}
\item{\code{class.probs}}{Data frame: \code{Profile}, \code{Probability}, \code{Frequency}.}
\item{\code{class.means}}{Matrix (first \code{I.max} variables) of true profile-specific means.}
\item{\code{cov_structure}}{Character: detailed description of covariance constraints.}
\item{\code{digits}, \code{I.max.shown}, \code{total.vars}}{Metadata for printing/formatting.}
}}

\item{\strong{\code{sim.LTA}}}{Returns a \code{summary.sim.LTA} object with components:
\describe{
\item{\code{call}}{Original simulation call.}
\item{\code{config}}{List: \code{N}, \code{I}, \code{L}, \code{times}, \code{type}, \code{distribution}, \code{constraint} (if LPA).}
\item{\code{class.probs}}{List of data frames (per time point): \code{Class}, \code{Probability}, \code{Frequency}.}
\item{\code{item.probs}}{Nested list (by time/item) of true conditional probabilities (if \code{type="LCA"}).}
\item{\code{class.means}}{List of matrices (by time) of true profile means (if \code{type="LPA"}).}
\item{\code{transition}}{List: \code{mode} ("fixed" or "covariate"), \code{rate} or \code{beta}/\code{gamma} coefficients, \code{time_points}.}
\item{\code{covariates}}{List of data frames (per time point) with covariate summaries (Min, Max, Mean), if present.}
\item{\code{digits}, \code{I.max.shown}, \code{L.max.shown}, \code{total.vars}, \code{total.classes}}{Metadata for printing/formatting.}
}}

\item{\strong{\code{fit.index}}}{Returns a \code{summary.fit.index} object with components:
\describe{
\item{\code{call}}{Function call that generated the fit indices.}
\item{\code{data.info}}{List: \code{N}.}
\item{\code{fit.table}}{Data frame: \code{Statistic}, \code{Value}, \code{Description} for -2LL, AIC, BIC, SIC, CAIC, AWE, SABIC.}
\item{\code{digits}}{Numeric: precision used for formatting.}
}}

\item{\strong{\code{compare.model}}}{Returns a \code{summary.compare.model} object with components:
\describe{
\item{\code{call}}{Function call that generated the comparison.}
\item{\code{data.info}}{List: \code{N}, \code{I}, \code{L} (named vector for two models).}
\item{\code{fit.table}}{Data frame comparing fit indices for both models.}
\item{\code{model_comparison}}{Data frame: \code{Classes}, \code{npar}, \code{AvePP}, \code{Entropy}.}
\item{\code{BF}}{Numeric: Bayes Factor value (if computed).}
\item{\code{BF_interpretation}}{Character: interpretive guidance for Bayes Factor.}
\item{\code{lrt_table}}{Data frame: \code{Test}, \code{Statistic}, \code{DF}, \code{p-value}, \code{Sig} (significance markers).}
\item{\code{lrt_objects}}{List: raw hypothesis test objects for further inspection.}
\item{\code{digits}}{Numeric: precision used for formatting.}
}}

\item{\strong{\code{SE}}}{Returns a \code{summary.SE} object with components:
\describe{
\item{\code{call}}{Original function call.}
\item{\code{method}}{Character: "Obs" or "Bootstrap".}
\item{\code{diagnostics}}{List: method-specific diagnostic info (e.g., n.Bootstrap, hessian_cond_number).}
\item{\code{model_type}}{Character: "LCA" or "LPA".}
\item{\code{L}}{Integer: number of latent classes/profiles.}
\item{\code{I}}{Integer: number of variables/items (NA if unknown).}
\item{\code{nonzero_counts}}{List: counts of non-zero SEs by parameter type (P.Z, means/par, covs).}
\item{\code{total_PZ}}{Integer: total number of class probability parameters.}
}}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{summary(LCA)}: Summary method for \code{LCA} objects

\item \code{summary(LPA)}: Summary method for \code{LPA} objects

\item \code{summary(LTA)}: Summary method for \code{LTA} objects

\item \code{summary(LCPA)}: Summary method for \code{LCPA} objects

\item \code{summary(sim.LCA)}: Summary method for \code{sim.LCA} objects

\item \code{summary(sim.LPA)}: Summary method for \code{sim.LPA} objects

\item \code{summary(sim.LTA)}: Summary method for \code{sim.LTA} objects

\item \code{summary(fit.index)}: Summary method for \code{fit.index} objects

\item \code{summary(compare.model)}: Summary method for \code{compare.model} objects

\item \code{summary(SE)}: Summary method for \code{summary.SE} objects

}}
