#' Generate All Permutations of N Variables
#'
#' Creates a matrix representing all possible combinations of N binary variables.
#' Each row corresponds to a unique combination, and each column represents a variable
#' where 1 indicates inclusion and 0 indicates exclusion.
#'
#' @param n Integer. Number of variables to generate permutations for.
#'
#' @return A matrix with \code{2^n} rows and \code{n} columns, where each row is a unique permutation of 0s and 1s.
#'
#' @details
#' This is an internal function called by \code{TTab} and is not intended for independent use.
#'
#' @author
#' Bethany Wolf \email{wolfb@@musc.edu}
#'
#' @keywords internal
Perms<-function(n)
{
  mat<-matrix(0, nrow=2^n, ncol=n)
  for(i in 1:n)
  {
    mat[,i]<-rep(0:1, times=2^(i-1), each=2^(n-i))
  }
  mat
}
