% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BinToNB.R
\name{BinToNB}
\alias{BinToNB}
\title{Convert multivariate binary data back to the original negative binomial scale}
\usage{
BinToNB(prop.vec.bin, NBprop, Mlocation, bin.data)
}
\arguments{
\item{prop.vec.bin}{A numeric vector of binary probabilities}

\item{NBprop}{A numeric value or vector of negative binomial proportions}

\item{Mlocation}{Integer indices of the medians in the vector}

\item{bin.data}{A data frame or matrix of generated multivariate binary data}
}
\value{
A list containing the multivariate negative binomial data and its correlation matrix
}
\description{
This function maps multivariate binary data to multivariate negative binomial outcomes,
preserving the original marginal distribution characteristics. Given a binary representation,
the function assigns negative binomial values based on the original probability
mass functions and the location of the median split for each variable.
}
\examples{
NB.r.vec <- c(10, 3, 16)
NB.prob.vec <- c(0.65, 0.4, 0.88)

# Compute binary probabilities, PMFs, and thresholds
p      <- calc.bin.prob.NB(NB.r.vec, NB.prob.vec)
pvec   <- p$p
prop   <- p$prop
Mloc   <- p$Mlocation

# Use only the first two variables for demonstration
pvec.pair      <- pvec[1:2]
Mlocation.pair <- Mloc[1:2]
prop.pair      <- list(prop[[1]], prop[[2]])

# Define a 2 by 2 target correlation matrix
del.next <- matrix(c(1.0, -0.3,
                     -0.3, 1.0),
                  nrow = 2, byrow = TRUE)

# Simulate 100 correlated binary observations
inter_bin <- generate.binaryVar(100, pvec.pair, del.next)

# Reconstruct the negative binomial scaled data
Mydata <- BinToNB(pvec.pair, prop.pair, Mlocation.pair, inter_bin)

}
