% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete_cont.R
\name{discrete_cont}
\alias{discrete_cont}
\title{Compute the tetrachoric correlation matrix for a multivariate standard normal distribution}
\usage{
discrete_cont(
  marginal,
  Sigma,
  support = list(),
  Spearman = FALSE,
  epsilon = 1e-06,
  maxit = 100
)
}
\arguments{
\item{marginal}{a list of \eqn{k} elements, where \eqn{k} is the number of variables.
The \eqn{i}-th element of \code{marginal} is the vector of the cumulative probabilities defining the marginal distribution of the \eqn{i}-th component of the  multivariate variable. If the \eqn{i}-th component can take \eqn{k_i} values, the \eqn{i}-th element of \code{marginal} will contain \eqn{k_i-1} probabilities (the \eqn{k_i}-th is obviously 1 and shall not be included).}

\item{Sigma}{the target correlation matrix of the discrete variables}

\item{support}{a list of \eqn{k} elements, where \eqn{k} is the number of variables. The \eqn{i}-th element of \code{support} is the vector containing the ordered values of the support of the \eqn{i}-th variable. By default, the support of the \eqn{i}-th variable is \eqn{1,2,...,k_i}}

\item{Spearman}{A logical flag indicating whether Spearman correlation should be used}

\item{epsilon}{tolerance of the algorithm convergence}

\item{maxit}{maximum iterations of the algorithm to correct PD matrix}
}
\value{
No return values; called it to check parameter inputs
}
\description{
This function calculates the intermediate correlation matrix of a multivariate
standard normal distribution in Step 2 of the algorithm. If the resulting matrix
is not positive definite, the nearest positive definite matrix is returned and
a warning is issued.
}
\examples{
prop.vec.bin = c(0.5037236, 0.5034147)
cor.mat = matrix(c(1, 0.3, 0.3, 1), nrow = 2, byrow = TRUE)
InterMVN_Sigma = discrete_cont(marginal = prop.vec.bin, Sigma = cor.mat)$SigmaC

}
\references{
Ferrari and Barbiero 2012 (<https://doi.org/10.1080/00273171.2012.692630>)
}
