% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallFcts.R
\name{HermiteN2X}
\alias{HermiteN2X}
\title{Inverse Hermite Polynomial}
\usage{
HermiteN2X(Type, H_N, N, Sig2 = NULL)
}
\arguments{
\item{Type}{A string specifying the type of Hermite polynomial inversion.
Must be either "Univariate" or "Multivariate".}

\item{H_N}{Input Hermite polynomials. For univariate, it is a vector. For multivariate, it is a list.}

\item{N}{The highest polynomial order.}

\item{Sig2}{The variance matrix of x for multivariate, or variance for univariate. Defaults to identity matrix for multivariate and 1 for univariate.}
}
\value{
A list of x powers: \eqn{x}, \eqn{x^{\otimes 2}}, ... , \eqn{x^{\otimes N}} for multivariate,
or a vector of x powers: \eqn{x^n}, \eqn{n=1:N} for univariate.
}
\description{
Compute the inverse of univariate or multivariate Hermite polynomials.
}
\details{
This function computes the powers of x when Hermite polynomials are given.
Depending on the type specified, it handles either univariate or multivariate
Hermite polynomials.
}
\examples{
# Univariate example
H_N_x <- c(1, 2, 3, 4)
x_powers <- HermiteN2X(Type = "Univariate", H_N = H_N_x, N = 4, Sig2 = 1)

# Multivariate example
x <- c(1, 3)
Sig2 <- diag(length(x))
N <- 4
H_N_X <- HermiteN(x, N, Type="Multivariate")
x_ad_n <- HermiteN2X(Type = "Multivariate", H_N = H_N_X, N = N, Sig2 = Sig2)

}
\references{
Gy.Terdik, Multivariate statistical methods - going beyond the linear,
Springer 2021. Section 4.6.2, (4.72), p.223 and Section 4.4, (4.23), p.198.
}
\seealso{
Other Hermite Polynomials: 
\code{\link{HermiteCoeff}()},
\code{\link{HermiteCov12}()},
\code{\link{HermiteN}()}
}
\concept{Hermite Polynomials}
