% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{loess.scatter}
\alias{loess.scatter}
\title{Draw a scatterplot with a fit line}
\usage{
loess.scatter(
  x,
  y,
  file = NULL,
  loess = TRUE,
  span = 0.75,
  scatter = plot,
  ...,
  ylim = NULL,
  return.vectors = FALSE,
  fit.col = "red",
  fit.lwd = 2,
  fit.lty = "solid",
  fit.leg = TRUE,
  fit.r2 = TRUE,
  fast.loess = FALSE
)
}
\arguments{
\item{x}{data for the horizontal axis (independent variable)}

\item{y}{data for the vertical axis (dependent variable)}

\item{file}{file name for pdf export, leave as NULL if simply plotting to the GUI. File 
extension will be added automatically if missing}

\item{loess}{logical, if TRUE, fit using loess(), else use a polynomial fit}

\item{span}{numeric scalar, argument passed to the 'span' parameter of loess(), see ?loess for details}

\item{scatter}{function, by default is graphics::plot(), but any scatter-plot function of the 
form F(x,y,...) can be used, for example graphics::smoothScatter().}

\item{...}{further arguments to the plot function specified by 'scatter', e.g, 'main', 'xlab', etc}

\item{ylim}{numeric range for y axis, argument passed to plot(), see ?plot.}

\item{return.vectors}{logical, if TRUE, do not plot anything, just return the x and y coordinates
of the fit line as a list of vectors, x and y.}

\item{fit.col}{colour of the fit line}

\item{fit.lwd}{width of the fit line}

\item{fit.lty}{type of the fit line}

\item{fit.leg}{whether to include an automatic legend for the fit line (will alter the y-limits
to fit)}

\item{fit.r2}{logical, whether to display r squared of the fit in the fit legend}

\item{fast.loess}{logical, if TRUE will alter control parameters to make the loess calculation
faster, which is useful for datasets with more than 1000 points. Also reduce the value of 'span'
to increase speed.}
}
\value{
if file is a character argument, plots data x,y to a file, else will generate a plot to
the current plotting environment/GUI. The display of the x,y points defaults to 'plot', but 
alternate scatter plot functions can be specified, such as graphics::smoothScatter() which used 
density smoothing, for example. Also, another option is to set return.vectors=TRUE, and then
the coordinates of the fit line will be returned, and no plot will be produced.
}
\description{
Drawing a fit line usually requires some manual steps requiring several lines of code,
such as ensuring the data is sorted by x, and for some functions doesn't contain missing values.
This function takes care of these steps and automatically adds a loess fitline, or non-linear 
fitline. The type of scatter defaults to 'plot', but other scatter plot functions can be 
specified, such as graphics::smoothScatter(), for example. If 'file' is specifed, will 
automatically plot to a pdf of that name.
}
\examples{
library(NCmisc)
require(KernSmooth)
DD <- sim.cor(1000,4) # create a simulated, correlated dataset
loess.scatter(DD[,3],DD[,4],loess=FALSE,bty="n",pch=".",cex=2)
loess.scatter(DD[,3],DD[,4],scatter=smoothScatter)
xy <- loess.scatter(DD[,3],DD[,4],return.vectors=TRUE)
prv(xy) # preview the vectors produced
}
