% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/engines_el_impl_core.R
\name{el_estimator_core}
\alias{el_estimator_core}
\title{Core of the empirical likelihood estimator}
\usage{
el_estimator_core(
  missingness_design,
  aux_matrix,
  aux_means,
  respondent_weights,
  analysis_data,
  outcome_expr,
  N_pop,
  formula,
  standardize,
  trim_cap,
  control,
  on_failure,
  family = logit_family(),
  variance_method,
  bootstrap_reps,
  start = NULL,
  trace_level = 0,
  auxiliary_means = NULL
)
}
\arguments{
\item{missingness_design}{Respondent-side missingness model design matrix (intercept + predictors).}

\item{aux_matrix}{Auxiliary design matrix on respondents (may have zero columns).}

\item{aux_means}{Named numeric vector of auxiliary population means (aligned to columns of \code{aux_matrix}).}

\item{respondent_weights}{Numeric vector of respondent weights aligned with \code{missingness_design} rows.}

\item{analysis_data}{Data object used for logging and variance.}

\item{outcome_expr}{Character string identifying the outcome expression displayed in outputs.}

\item{N_pop}{Population size on the analysis scale.}

\item{formula}{Original model formula used for estimation.}

\item{standardize}{Logical. Whether to standardize predictors during estimation.}

\item{trim_cap}{Numeric. Upper bound for empirical likelihood weight trimming.}

\item{control}{List of control parameters for the nonlinear equation solver.}

\item{on_failure}{Character. Action when solver fails.}

\item{family}{List. Link function specification.}

\item{variance_method}{Character. Variance estimation method.}

\item{bootstrap_reps}{Integer. Number of bootstrap replications.}

\item{auxiliary_means}{Named numeric vector of known population means supplied by the user.}
}
\value{
List containing estimation results, diagnostics, and metadata.
}
\description{
Core of the empirical likelihood estimator
}
\keyword{internal}
