% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLIW.r
\name{HLIW}
\alias{HLIW}
\alias{dHL.inv.weib}
\alias{pHL.inv.weib}
\alias{qHL.inv.weib}
\alias{rHL.inv.weib}
\alias{hHL.inv.weib}
\title{Half-Logistic Inverted Weibull (HLIW) Distribution}
\usage{
dHL.inv.weib(x, alpha, beta, lambda, log = FALSE)
pHL.inv.weib(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qHL.inv.weib(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rHL.inv.weib(n, alpha, beta, lambda)
hHL.inv.weib(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric shape parameter}

\item{beta}{positive numeric rate parameter}

\item{lambda}{positive numeric shape parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dHL.inv.weib}: numeric vector of (log-)densities
  \item \code{pHL.inv.weib}: numeric vector of probabilities
  \item \code{qHL.inv.weib}: numeric vector of quantiles
  \item \code{rHL.inv.weib}: numeric vector of random variates
  \item \code{hHL.inv.weib}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Half-Logistic Inverted Weibull distribution.
}
\details{
The HLIW distribution is parameterized by shape parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Half-Logistic Inverted Weibull (HLIW) distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\frac{1-\left\{1-e^{-\alpha x^{-\beta}}\right\}^\lambda}
{1+\left\{1-e^{-\alpha x^{-\beta}}\right\}^\lambda} \, ; \quad   x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The implementation includes the following functions:
\itemize{
  \item \code{dHL.inv.weib()} — Density function
  \item \code{pHL.inv.weib()} — Distribution function
  \item \code{qHL.inv.weib()} — Quantile function
  \item \code{rHL.inv.weib()} — Random generation
  \item \code{hHL.inv.weib()} — Hazard function
}
}
\examples{
x <- seq(0.1, 5, 0.1)
dHL.inv.weib(x, 1.5, 0.8, 2)
pHL.inv.weib(x, 1.5, 0.8, 2)
qHL.inv.weib(0.5, 1.5, 0.8, 2)
rHL.inv.weib(10, 1.5, 0.8, 2)
hHL.inv.weib(x, 1.5, 0.8, 2)

#Data
x <- survtimes
gofic(x,
      params = list(alpha=31.1650, beta=0.4213, lambda=45.5485),
      dfun = dHL.inv.weib, pfun = pHL.inv.weib, plot=TRUE, verbose = TRUE)

pp.plot(x,
        params = list(alpha=31.1650, beta=0.4213, lambda=45.5485),
        pfun = pHL.inv.weib, fit.line=TRUE)

qq.plot(x,
        params = list(alpha=31.1650, beta=0.4213, lambda=45.5485),
        qfun = qHL.inv.weib, fit.line=TRUE)

}
\references{
Elgarhy, M., ul Haq, M.A. & Perveen, I. (2019).  
Type II Half Logistic Exponential Distribution with Applications. 
\emph{Ann. Data. Sci.}, \bold{6}, 245--257 \doi{10.1007/s40745-018-0175-y}

Chaudhary, A. K., & Kumar, V. (2020). 
Half Logistic Exponential Extension Distribution with Properties and Applications. 
\emph{International Journal of Recent Technology and Engineering (IJRTE)}, 
\bold{8(3)}, 506--512. \doi{10.35940/ijrte.C4625.099320} 

Dhungana, G.P. & Kumar, V.(2022). 
Half Logistic Inverted Weibull Distribution: Properties and Applications.
\emph{J. Stat. Appl. Pro. Lett.}, \bold{9(3)}, 161--178. \doi{10.18576/jsapl/090306}
}
