% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonGenRayleigh.r
\name{PoissonGenRayleigh}
\alias{PoissonGenRayleigh}
\alias{dpois.gen.rayleigh}
\alias{ppois.gen.rayleigh}
\alias{qpois.gen.rayleigh}
\alias{rpois.gen.rayleigh}
\alias{hpois.gen.rayleigh}
\title{Poisson Generalized Rayleigh (PGR) Distribution}
\usage{
dpois.gen.rayleigh(x, alpha, beta, lambda, log = FALSE)
ppois.gen.rayleigh(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.gen.rayleigh(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.gen.rayleigh(n, alpha, beta, lambda)
hpois.gen.rayleigh(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.gen.rayleigh}: numeric vector of (log-)densities
  \item \code{ppois.gen.rayleigh}: numeric vector of probabilities
  \item \code{qpois.gen.rayleigh}: numeric vector of quantiles
  \item \code{rpois.gen.rayleigh}: numeric vector of random variates
  \item \code{hpois.gen.rayleigh}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the PGR distribution.
}
\details{
The PGR distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The PGR distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad \frac{1}{\left(1-e^{-\lambda}\right)}\left[1-\exp 
\left\{-\lambda\left(1-e^{-\beta x^2}\right)
^\alpha\right\}\right]  \quad ;\;x > 0.
}
 
where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dpois.gen.rayleigh()} — Density function
  \item \code{ppois.gen.rayleigh()} — Distribution function
  \item \code{qpois.gen.rayleigh()} — Quantile function
  \item \code{rpois.gen.rayleigh()} — Random generation
  \item \code{hpois.gen.rayleigh()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dpois.gen.rayleigh(x, 2.0, 0.5, 0.2)
ppois.gen.rayleigh(x, 2.0, 0.5, 0.2)
qpois.gen.rayleigh(0.5, 2.0, 0.5, 0.2)
rpois.gen.rayleigh(10, 2.0, 0.5, 0.2)
hpois.gen.rayleigh(x, 2.0, 0.5, 0.2)

# Data
x <- stress
# ML estimates
params = list(alpha=1.5466, beta=0.0211, lambda=16.4523)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.gen.rayleigh, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.gen.rayleigh, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
            dfun = dpois.gen.rayleigh, pfun=ppois.gen.rayleigh, plot=TRUE)
print.gofic(out)

}
\references{
Joshi, R.K., & Kumar, V. (2021). 
Poisson Generalized Rayleigh Distribution with Properties and Application.
\emph{International Journal of Statistics and Applied Mathematics}, 
\bold{6(1)}, 90--99. \doi{10.22271/maths.2021.v6.i1b.637}
}
