% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nretention.r
\name{ind_nretention}
\alias{ind_nretention}
\title{Calculate the indicator for N retention for groundwater or surface water}
\usage{
ind_nretention(D_NW, leaching_to)
}
\arguments{
\item{D_NW}{(numeric) The value of N leaching calculated by \code{\link{calc_nleach}}}

\item{leaching_to}{(character) whether it evaluates N leaching to groundwater ("gw") or to surface water ("ow")}
}
\value{
The evaluated score for the soil function to supply nitrogen for crop uptake. A numeric value between 0 and 1.
}
\description{
This function calculates the indicator for the N retention of the soil by using the N leaching to groundwater or surface water calculated by \code{\link{calc_nleach}}
}
\examples{
ind_nretention(D_NW = 15,leaching_to = 'gw')
ind_nretention(D_NW = c(.2,5.6,15.6),leaching_to = 'ow')
 
}
