% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encontrar_raices.R
\name{encontrar_raices}
\alias{encontrar_raices}
\title{Identifies the roots of a univariate function over a given interval by
subdividing the interval into smaller subintervals and applying
\code{\link[stats]{uniroot}} on those subintervals where a sign change is detected.}
\usage{
encontrar_raices(intersection_function, interval, n_subintervals = 10)
}
\arguments{
\item{intersection_function}{A univariate numeric function whose roots are
to be located.}

\item{interval}{Numeric vector of length 2 specifying the lower and upper
bounds of the search interval.}

\item{n_subintervals}{Integer. Number of subintervals used to partition
\code{interval}.}
}
\value{
A numeric vector containing the distinct roots found within \code{interval}.
If no roots are detected, an empty numeric vector is returned.
}
\description{
Identifies the roots of a univariate function over a given interval by
subdividing the interval into smaller subintervals and applying
\code{\link[stats]{uniroot}} on those subintervals where a sign change is detected.
}
\keyword{internal}
