% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foldchange.R
\name{foldchange}
\alias{foldchange}
\title{Computes Log2(A) - Log2(B) Fold Change of (non-) paired data.}
\usage{
foldchange(
  data,
  feature_rank,
  condition_A,
  condition_B,
  condition_labels,
  paired = FALSE
)
}
\arguments{
\item{data}{A \link[data.table]{data.table}.}

\item{feature_rank}{A character variable of the feature level (e.g. "Genus" in taxonomy).}

\item{condition_A}{A vector of categorical characters, it is possible to specify multiple labels.}

\item{condition_B}{A vector of categorical characters, it is possible to specify multiple labels.}

\item{condition_labels}{A vector character wherein \code{condition_A} and \code{condition_B} are present.}

\item{paired}{A Boolean value to perform paired or non-paired test, see \link[stats]{wilcox.test}.}
}
\value{
A \link[data.table]{data.table}
}
\description{
Computes (non-)paired Log2(A) - Log2(B) Fold Change.
This function is built into the class \link{omics} with method \code{DFE()} and inherited by other omics classes, such as;
\link{metagenomics} and \link{proteomics}. The function handles zero's, and doesn't return +/- infinites.
}
\examples{
#-------------------------#
##      NON-PAIRED       ##
#-------------------------#
library(data.table)

# Define parameters and variables
sample_ids <- c("S1", "S2", "S3", "S4", "S5", "S6")
groups <- c("A", "A", "B", "B", "C", "C")
feature_ids <- c("Feature1", "Feature2", "Feature3")

# Simulated abundance matrix (features x samples)
abundances <- matrix(
  c(
    100, 120, 110, 55, 60, 65,
    50, 65, 60, 130, 120, 125,
    80, 85, 90, 80, 85, 90
  ),
  nrow = 3, byrow = TRUE,
  dimnames = list(feature_ids, sample_ids)
)

# Convert to a data.table
mock_data <- OmicFlow::matrix_to_dtable(abundances)
mock_data$Genus <- feature_ids

# It uses exact matching and multiple conditions are allowed.
res <- foldchange(
  data = mock_data,
  feature_rank = "Genus",
  condition_A = c("A", "B"),
  condition_B = c("B", "C"),
  condition_labels = groups,
  paired = FALSE
)
print(res)

#---------------------#
##      PAIRED       ##
#---------------------#
library(data.table)

# In the paired case both conditions A and B must be of the same length!
# We re-use the above mock_data and only change group labels
groups <- c("A", "A", "B", "B", "A", "B")

res <- foldchange(
  data = mock_data,
  feature_rank = "Genus",
  condition_A = c("A"),
  condition_B = c("B"),
  condition_labels = groups,
  paired = TRUE
)
print(res)

}
