% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwelch.R
\name{pwelch}
\alias{pwelch}
\title{Estimate Power Spectral Density Using Welch's Method}
\usage{
pwelch(
  x,
  nfft,
  noverlap = 0,
  sr = NULL,
  window = NULL,
  demean = c("long", "short", "none"),
  channel = 1
)
}
\arguments{
\item{x}{input signal, either a numeric vector, \link[tuneR]{Wave},
\link[tuneR]{WaveMC}, or \code{audioSample} object. Can also be
a path to a wav file and it will be read in}

\item{nfft}{length of FFT window to use for individual frames}

\item{noverlap}{number of samples each frame should overlap}

\item{sr}{sample rate of data, only necessary if \code{x} is a vector}

\item{window}{window to apply, must be a vector of length \code{nfft}.
If \code{NULL} (default), then a \link[signal]{hamming} window will
 be used}

\item{demean}{method of demeaning the signal, one of \code{'long'},
\code{'short'}, or \code{'none'}. Long subtracts the mean of the
entire signal \code{x}, short subtracts the mean of each individual
frame, none does no mean subtraction.}

\item{channel}{channel number to analyse, ignored if \code{x} is a vector}
}
\value{
returns a list with items \code{spec}, the PSD estimate of the
  input signal, and \code{freq}, the frequency values (Hz) at
  each value of \code{spec}
}
\description{
Estimates the power spectral density (PSD) of an
  input signal using Welch's method. This should function
  similarly to the Matlab function pwelch, but results may
  not be identical. Breaks the input signal into (usually)
  overlapping frames and averages the resulting PSD estimates
}
\examples{
# wav example is synthetic echolocation clicks at 4kHz
wavFile <- system.file('extdata/testWav.wav', package='PAMmisc')
psd <- pwelch(wavFile, nfft=1e3, noverlap=500, demean='long')
plot(x=psd$freq, y=10*log10(psd$spec), type='l')

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
