% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateNegexpPoints.R
\name{integrateNegexpPoints}
\alias{integrateNegexpPoints}
\title{Integrate Negative exponential point surveys}
\usage{
integrateNegexpPoints(
  object,
  newdata = NULL,
  w.lo = NULL,
  w.hi = NULL,
  Units = NULL
)
}
\arguments{
\item{object}{Either an Rdistance fitted distance function
(an object that inherits from class "dfunc"; usually produced 
by a call to \code{\link{dfuncEstim}}), or a matrix of canonical 
distance function parameters (e.g., \code{matrix(exp(fit$par),1)}). 
If a matrix, each row corresponds to a 
distance function and each column is a parameter. The first column is 
the parameter related to sighting covariates and must be transformed 
to the "real" space (i.e., inverse link, which is \eqn{exp()}, must 
be applied outside this routine).  If \code{object} is a matrix, 
it should not have measurement units because
only derived quantities (e.g., ESW) have units; Rdistance function 
parameters themselves never have units.}

\item{newdata}{A data frame containing new values for 
the distance function covariates. If NULL and 
\code{object} is a fitted distance function, the  
observed covariates stored in
\code{object} are used (behavior similar to \code{\link{predict.lm}}).
Argument \code{newdata} is ignored if \code{object} is a matrix.}

\item{w.lo}{Minimum sighting distance or left-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function. 
Must have physical measurement units.}

\item{w.hi}{Maximum sighting distance or right-truncation value
if \code{object} is a matrix.
Ignored if \code{object} 
is a fitted distance function.
Must have physical measurement units.}

\item{Units}{Physical units of sighting distances if 
\code{object} is a matrix. Sighting distance units can differ from units 
of \code{w.lo} or \code{w.hi}.   Ignored if \code{object}
is a fitted distance function.}
}
\value{
A vector of areas under the distance functions represented in 
\code{object}. 
If \code{object} is a distance function and 
\code{newdata} is specified, the returned vector's length is 
\code{nrow(newdata)}.  If \code{object} is a distance function and 
\code{newdata} is NULL, 
returned vector's length is \code{length(distances(object))}. If 
\code{object} is a matrix, return's length is 
\code{nrow(object)}.
}
\description{
Compute integral of the negative exponential distance function
for point surveys
}
\details{
Returned integrals are
\deqn{\int_0^{w} xe^{-a_i x} dx = \frac{1 - e^{-a_i w} (a_i w + 1)}{a_i^2},}{
Integral( x exp(-a*x) ) = (1 - exp(-a*w)(a*w + 1)) / a^2,}
where \eqn{w = w.hi - w.lo} and \eqn{a_i}{a} is the estimated 
negative exponential distance 
function parameter for the 
i-th observed distance.
}
\section{Note}{

Users will not normally call this function. It is called 
internally by \code{\link{nLL}} and \code{\link{effectiveDistance}}.
}

\examples{

# Fake distance function object w/ minimum inputs for integration
d <- rep(1,4) \%#\% "m" # Only units needed, not values
obs <- factor(rep(c("obs1", "obs2"), 2))
beta <- c(-5, -0.5)
w.hi <- 125
w.lo <- 20
ml <- list(
    mf = model.frame(d ~ obs)
  , par = beta 
  , likelihood = "negexp"
  , w.lo = w.lo \%#\% "m"
  , w.hi = w.hi \%#\% "m"
  , expansions = 0
)
class(ml) <- "dfunc"
integrateNegexpPoints(ml)

# Check: Integral of x*exp(-bx) from 0 to w.hi-w.lo
b <- c(exp(beta[1]), exp(beta[1] + beta[2]))
intgral <- (1 - exp(-b*(w.hi - w.lo)) * (b*(w.hi - w.lo) + 1)) / (b^2)
intgral


}
\seealso{
\code{\link{integrateNumeric}}; \code{\link{integrateNegexpLines}}
}
