% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionBootFER.R
\name{distributionBootFER}
\alias{distributionBootFER}
\title{Bootstrap a null distribution of the test statistic for fixed effect model}
\usage{
distributionBootFER(
  nBoot,
  seed,
  parametric = TRUE,
  FERSObject1,
  FERSObject2,
  splineRule,
  lmFormula,
  varName,
  knotType = 1,
  nBasis = 5,
  increasing = TRUE,
  convex = TRUE,
  testStat = NULL
)
}
\arguments{
\item{nBoot}{The number of bootstrap iterations.}

\item{seed}{The seed.}

\item{parametric}{The method of noise bootstrap: T=resample from estimated noise, F=resample from normal}

\item{FERSObject1}{The lm model under null distribution.}

\item{FERSObject2}{The lm model fitted using iSplineFER or cSplineFER}

\item{splineRule}{iSplineFER or cSplineFER}

\item{lmFormula}{A linear model formula (same as lmFormula in iSplineFER or cSplineFER).}

\item{varName}{The name of the main effect (same as varName in iSplineFER or cSplineFER).}

\item{knotType}{The knot type: 1=equal-spaced and 2=quantile (same as knotType in iSplineFER or cSplineFER).}

\item{nBasis}{The number of bases (same as nBasis in iSplineFER or cSplineFER).}

\item{increasing}{Increasing shape or Decreasing shape: T=Increasing, F=Decreasing}

\item{convex}{Convex shape or Concave shape: T=Convex, F=Concave}

\item{testStat}{The test statistic generated from iSplineFER or cSplineFER}
}
\value{
A list of null distribution of test statistic and p value.
}
\description{
Bootstrap a null distribution of the test statistic for fixed effect model
}
\keyword{internal}
