% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Saturn_coefficient.r
\name{calculatesSaturnContinuityTrustworthiness}
\alias{calculatesSaturnContinuityTrustworthiness}
\title{Function that calculates the Saturn coefficient, trustworthiness score, and the continuity score of a UMAP dimensionality reduction}
\usage{
calculatesSaturnContinuityTrustworthiness(
  original_matrix,
  umap_output_layout,
  VERBOSE
)
}
\arguments{
\item{original_matrix}{input matrix}

\item{umap_output_layout}{output matrix of UMAP applied to original_matrix}

\item{VERBOSE}{prints some intermediate message to standard output or not}
}
\value{
a dataframe containing the Saturn coefficient, the trustworthiness score, and the continuity score
}
\description{
Function that calculates the Saturn coefficient, trustworthiness score, and the continuity score of a UMAP dimensionality reduction
}
\examples{

this_nrows <- 200
this_ncols <- 100
this_min <- 0
this_max <- 10000
noise_random_matrix <- matrix(runif(n = this_nrows * this_ncols,
     min = this_min, max = this_max), nrow = this_nrows)
input_matrix <- as.matrix(noise_random_matrix)
these_nearest_neighbors <- 15
this_min_dist <- 0.05

library("umap")
custom.settings <- umap::umap.defaults
custom.settings$"n_neighbors" <- these_nearest_neighbors
custom.settings$"min_dist" <- this_min_dist

x_umap <- umap::umap(input_matrix, config=custom.settings)

this_verbose <- FALSE
theseThreeMetrics <- calculatesSaturnContinuityTrustworthiness(input_matrix,
     x_umap$"layout",  this_verbose)
print(theseThreeMetrics)
}
