% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_stpp.R
\name{plot_stpp}
\alias{plot_stpp}
\title{Plot a spatio-temporal point pattern}
\usage{
plot_stpp(data, type = c("3D", "space", "time"), time_bins = 30, title = NULL)
}
\arguments{
\item{data}{A numeric matrix or data frame with at least three columns representing event coordinates.
If \code{data} is a matrix, the first three columns are interpreted as \code{x}, \code{y}, and \code{t}.
If \code{data} is a data frame, the function uses columns named \code{x}, \code{y}, \code{t} when present;
otherwise it uses the first three columns.}

\item{type}{Character string specifying the type of visualization to produce:
\code{"3D"} for a three-dimensional scatterplot;
\code{"space"} for a 2D spatial plot of \code{x} versus \code{y};
or \code{"time"} for a histogram of event times with a smoothed density overlay.}

\item{time_bins}{Integer specifying the number of bins in the histogram when \code{type = "time"}.
Default is 30.}

\item{title}{Optional character string giving a plot title. If \code{NULL}, a default title is used.}
}
\value{
Produces a plot as a side effect. Nothing is returned.
}
\description{
Provides flexible visualization tools for spatio-temporal point patterns.
Depending on the chosen display type, the function produces one of three plots:
\itemize{
\item A 3D scatterplot showing event locations in space–time (\code{"3D"});
\item A 2D spatial projection of points in the spatial plane (\code{"space"});
\item A temporal histogram with an overlaid kernel density curve (\code{"time"}).
}
The input dataset must contain three columns corresponding to the spatial (\code{x}, \code{y})
and temporal (\code{t}) coordinates of events.
}
\details{
The function serves as an exploratory tool for investigating the spatial,
temporal, or joint space–time structure of point pattern data.
Such visualization is often a first step before conducting statistical analyses
of separability or intensity modeling (see Ghorbani et al., 2021).

\describe{
\item{\strong{3D mode}}{Displays events in a 3D coordinate system using the
\pkg{scatterplot3d} package, allowing a quick assessment of clustering
and temporal trends in space--time.}
\item{\strong{Spatial mode}}{Projects points onto the spatial plane (\code{x}--\code{y}),
showing spatial structure independent of time.}
\item{\strong{Temporal mode}}{Displays the marginal temporal distribution of
events as a histogram with a kernel density overlay, facilitating the
visual detection of temporal nonstationarity.}
}

Visualization is particularly useful for validating the realism of simulated
data (e.g. from \code{\link{rstpoispp}} or \code{\link{Gauss.st.F}})
and for preliminary inspection prior to applying tests such as
\code{\link{chi2.test}}, \code{\link{global.envelope.test}}, or
\code{\link{dHS.test}}.
}
\note{
The 3D visualization requires the \pkg{scatterplot3d} package.
}
\examples{

\donttest{
set.seed(123)
X <- cbind(runif(100), runif(100), runif(100, 0, 10))

# Visualize point pattern in 3D space–time
plot_stpp(X, type = "3D")

# View spatial projection
plot_stpp(X, type = "space")

# Inspect temporal distribution
plot_stpp(X, type = "time", time_bins = 20)
}

}
\references{
Ghorbani M., Vafaei N., Dvořák J., Myllymäki M. (2021).
Testing the first-order separability hypothesis for spatio-temporal point patterns.
\emph{Computational Statistics & Data Analysis}, \bold{161}, 107245.
}
\seealso{
\code{\link{rstpoispp}},
\code{\link{estimate.st.intensity}},
\code{\link{plot_stlgcp}},
\code{\link{chi2.test}},
\code{\link{dHS.test}}
}
\author{
Nafiseh Vafaei \email{nafiseh.vafaei@slu.se}
}
