% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simultion_procedure.R
\name{sim.procedures}
\alias{sim.procedures}
\title{Generate permuted versions (pure or block) of a spatio-temporal point pattern}
\usage{
sim.procedures(X, nperm = 1999, nblocks = 4, method = c("block", "pure"))
}
\arguments{
\item{X}{A numeric matrix or data frame with at least three columns, where the third column represents time.}

\item{nperm}{Integer. The number of permuted datasets to generate.}

\item{nblocks}{Integer. The number of temporal blocks to use for block permutation. Must be > 2.}

\item{method}{Character. The permutation strategy to use. One of \code{"pure"} or \code{"block"}.}
}
\value{
A list of \code{nperm} matrices. Each matrix is a permuted version of the original input \code{X}, where the third column (time) has been resampled based on the selected method.
}
\description{
Implements two types of permutation procedures for resampling the time component of spatio-temporal point process data:
\describe{
\item{\code{"pure"}}{Pure random permutation of the time coordinates.}
\item{\code{"block"}}{Block permutation where the time dimension is divided into consecutive blocks, and permutations are applied at the block level.}
}
These procedures are used for generating surrogate datasets under the null hypothesis of first-order separability.
}
\examples{

set.seed(123)
X <- cbind(runif(100), runif(100), sort(runif(100)))

# Pure permutation
sims_pure <- sim.procedures(X, nperm = 10, method = "pure")
head(sims_pure[[1]])
# Block permutation
sims_block <- sim.procedures(X, nperm = 10, nblocks = 5, method = "block")

# Visualize the first result from block permutation
plot_stpp(sims_block[[1]], type = "3D")

}
