% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-levey_jennings.R
\name{plot_levey_jennings}
\alias{plot_levey_jennings}
\title{Plot Levey-Jennings chart}
\usage{
plot_levey_jennings(
  list_of_plates,
  analyte_name,
  dilution = "1/400",
  sd_lines = c(1, 2, 3),
  mfi_log_scale = TRUE,
  sort_plates = TRUE,
  plate_labels = "number",
  label_angle = 0,
  legend_position = "bottom",
  data_type = "Median"
)
}
\arguments{
\item{list_of_plates}{A list of plate objects for which to plot the
Levey-Jennings chart}

\item{analyte_name}{(\code{character(1)}) the analyte for which to plot the
Levey-Jennings chart}

\item{dilution}{(\code{character(1)}) the dilution for which to plot the
Levey-Jennings chart. The default is "1/400"}

\item{sd_lines}{(\code{numeric}) the vector of coefficients for the
standard deviation lines to plot, for example, c(1.96, 2.58)
will plot four horizontal lines: mean +/- 1.96\emph{sd, mean +/- 2.58}sd
default is c(1, 2, 3) which will plot 6 lines in total}

\item{mfi_log_scale}{(\code{logical(1)}) specifies if the MFI should be in the \code{log10} scale.
By default it equals to \code{TRUE}, which corresponds to plotting the chart in \code{log10} scale.}

\item{sort_plates}{(\code{logical(1)}) if \code{TRUE} sorts plates by the date of examination.
If \code{FALSE} plots using the plate order as in input. \code{TRUE} by default.}

\item{plate_labels}{(\code{character(1)}) controls x-axis labels. Can improve readibility of the plot. Takes the following values:
\itemize{
\item \code{"numbers"}: shows the number of the plate,
\item \code{"names"}: shows the plate names
\item \code{"dates"}: shows the date of examination
}}

\item{label_angle}{(\code{numeric(1)}) angle in degrees to rotate x-axis labels. Can improve readibility of the plot. Default: 0}

\item{legend_position}{the position of the legend, a possible values are \code{c(right, bottom, left, top, none)}. Is not used if \code{plot_legend} equals to \code{FALSE}.}

\item{data_type}{(\code{character(1)}) the type of data used plot. The default is "Median"}
}
\value{
A ggplot object with the Levey-Jennings chart
}
\description{
The function plots a Levey-Jennings chart for the given analyte
in the list of plates. The Levey-Jennings chart is a graphical
representation of the data that enables the detection of outliers
and trends. It is a quality control tool that is widely used
in the laboratories across the world.

The method takes several parameters that can customise its output.
Except for the required parameters (\code{list_of_plates} and \code{analyte_name}),
the most significant optional ones are \code{dilution} and \code{sd_lines}.

The additional parameters can be used for improving the plots interpretability, by customizing the layout, y-scale, etc.

For better readibilty, the plot is zoomed out in the \code{y}-axis, by a factor of \code{1.5}.
}
\examples{
# creating temporary directory for the example
output_dir <- tempdir(check = TRUE)

dir_with_luminex_files <- system.file("extdata", "multiplate_reallife_reduced",
  package = "SerolyzeR", mustWork = TRUE
)
list_of_plates <- process_dir(dir_with_luminex_files,
  return_plates = TRUE, format = "xPONENT", output_dir = output_dir
)
list_of_plates <- rep(list_of_plates, 10) # since we have only 3 plates i will repeat them 10 times

plot_levey_jennings(list_of_plates, "ME", dilution = "1/400", sd_lines = c(0.5, 1, 1.96, 2.58))

}
