% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Annotation_PerCell.R
\name{Celltype_Annotation_PerCell}
\alias{Celltype_Annotation_PerCell}
\title{Annotate Seurat Object with Per-Cell SlimR Predictions}
\usage{
Celltype_Annotation_PerCell(
  seurat_obj,
  SlimR_percell_result,
  plot_UMAP = TRUE,
  annotation_col = "Cell_type_PerCell_SlimR",
  plot_confidence = FALSE
)
}
\arguments{
\item{seurat_obj}{A Seurat object.}

\item{SlimR_percell_result}{List generated by Celltype_Calculate_PerCell() containing
Cell_annotations data.frame with Cell_barcode and Predicted_cell_type columns.}

\item{plot_UMAP}{Logical; if TRUE, plot the UMAP with cell type annotations. Default: TRUE.}

\item{annotation_col}{Column name to write in meta.data. Default: "Cell_type_PerCell_SlimR".}

\item{plot_confidence}{Logical; if TRUE, also plot a UMAP colored by confidence scores. Default: FALSE.}
}
\value{
A Seurat object with updated meta.data containing:
\itemize{
\item annotation_col: Predicted cell type for each cell
\item paste0(annotation_col, "_score"): Max score for each cell
\item paste0(annotation_col, "_confidence"): Confidence score for each cell
}
}
\description{
This function assigns SlimR per-cell predicted cell types directly to
individual cells in a Seurat object's meta.data slot.
}
\note{
If plot_UMAP = TRUE, this function will print UMAP plot(s) as a side effect.
}
\examples{
\dontrun{
# Run per-cell annotation
result <- Celltype_Calculate_PerCell(
    seurat_obj = sce,
    gene_list = Markers_list,
    species = "Human"
)

# Annotate Seurat object
sce <- Celltype_Annotation_PerCell(
    seurat_obj = sce,
    SlimR_percell_result = result,
    plot_UMAP = TRUE,
    annotation_col = "Cell_type_PerCell_SlimR"
)
}

}
\seealso{
Other Section_3_Automated_Annotation: 
\code{\link{Celltype_Annotation}()},
\code{\link{Celltype_Calculate}()},
\code{\link{Celltype_Calculate_PerCell}()},
\code{\link{Celltype_Verification}()},
\code{\link{Celltype_Verification_PerCell}()},
\code{\link{Parameter_Calculate}()},
\code{\link{percell_workflow}}
}
\concept{Section_3_Automated_Annotation}
