% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_scale.R
\name{p_scale}
\alias{p_scale}
\title{p-value from Scale Test simulation}
\usage{
p_scale(
  n,
  scale,
  n2_n1 = 1,
  two.tailed = TRUE,
  exact = NULL,
  test = "Ansari",
  parent = function(n, ...) rnorm(n),
  ...,
  return_analysis = FALSE
)
}
\arguments{
\item{n}{sample size per group}

\item{scale}{the scale to multiply the second group by (1 reflects equal scaling)}

\item{n2_n1}{sample size ratio}

\item{two.tailed}{logical; use two-tailed test?}

\item{exact}{a logical indicating whether an exact p-value should be computed}

\item{test}{type of method to use. Can be either \code{'Ansari'} or \code{'Mood'}}

\item{parent}{data generation function (default assumes Gaussian shape). Must be
population mean centered}

\item{...}{additional arguments to pass to simulation functions (if used)}

\item{return_analysis}{logical; return the analysis object for further
extraction and customization?}
}
\value{
a single p-value
}
\description{
Simulates data given one or two parent distributions and
returns a p-value testing that the scale of the type distributions are the same.
Default implementation uses Gaussian distributions, however the
distribution function may be modified to
reflect other populations of interest.
Uses \code{\link{ansari.test}} or \code{\link{mood.test}} for the analysis.
}
\examples{

# n=30 per group,
#  Distributions Gaussian with sd=1 for first group and sd=2 for second
p_scale(30, scale=2)
p_scale(30, scale=2, test='Mood')

# compare chi-squared distributions
parent <- function(n, df, ...) rchisq(n, df=df) - df
p_scale(30, scale=2, parent=parent, df=3)

\donttest{
  # empirical power of the experiments
  p_scale(30, scale=2) |> Spower()
  p_scale(30, scale=2, test='Mood') |> Spower()

  p_scale(30, scale=2, parent=parent, df=3) |> Spower()
  p_scale(30, scale=2, test='Mood', parent=parent, df=3) |> Spower()

}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
