% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{Meanscan}
\alias{Meanscan}
\title{Calculate less robust geostatistical indices (mean of absolute differences raised to an exponent)}
\usage{
Meanscan(inRaster, kernels, w, exponent)
}
\arguments{
\item{inRaster}{The DEM/residual-dem/image from which to compute the indices}

\item{kernels}{The kernels to be used for computing the directional differences (e.g. order 1 or 2 for various lags)}

\item{w}{The moving window adopted for computing the geostatistical index (i.e., MAD)}

\item{exponent}{The exponent: increasing the exponent increase the sensitivity to outliers. Set 2 for Variogram and 1 for Madogram.}
}
\value{
A SpatRaster with 3 layers: 1)isotropic roughness; 2) direction of anisotropy; 3)index of anisotropy.
}
\description{
With this you can compute variogram and madogram (but remember that for
conventional geostatistical indices you need to divide the derived isotropic index by 2!).
Moreover you can calibrate the exponent in order to filter or enhance hotspots and discontinuities
}
\examples{
#' Variogram-like for lag 2 with differences of order 2 using a circular search window of radius 3.
# Using differences of order 1, you should
# apply these on a detrended surface/image.
library(terra)
dem=rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
w=KernelCircular(3)
rough2c=Meanscan(dem,k2ck2, w,2)
#(divide by two if you need conventional estimator)
plot(rough2c$IsoRough)

}
