% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visuals.R
\name{plot_persist}
\alias{plot_persist}
\title{Plot Persistent Homology as Persistence Diagram}
\usage{
plot_persist(feature.matrix, flat = FALSE, cutoff = 0)
}
\arguments{
\item{feature.matrix}{nx3 matrix representing persistent homology features}

\item{flat}{default FALSE; if TRUE, plots flat persistent homology instead}

\item{cutoff}{threshold for significant features; line added as marker on plot}
}
\value{
ggplot instance representing persistence diagram
}
\description{
Plots a feature matrix as a persistence diagram. See `plot_barcode` for an
alternate visualization method of persistent homology.
}
\details{
The `feature.matrix` parameter should be a numeric matrix with each
row corresponding to a single feature. It should have 3 columns
corresponding to feature dimension (col 1), feature birth (col 2), and
feature death (col 3). The first column should be filled with integers,
and the next two columns should be filled with numeric values.
The output from the `calculate_homology` function in this package will be a
valid value for the `feature.matrix` parameter.

This function uses the ggplot2 framework to generate persistence diagrams.
For details, see: Wickham H (2009, ISBN:9780387981413). ggplot2: Elegant Graphics for Data
Analysis. Springer-Verlag: New York, NY.
}
\examples{

# create a 2-d point cloud of a circle (100 points)
num.pts <- 100
rand.angle <- runif(num.pts, 0, 2*pi)
pt.cloud <- cbind(cos(rand.angle), sin(rand.angle))

# calculate persistent homology (num.pts by 3 numeric matrix)
pers.hom <- calculate_homology(pt.cloud)

# plot calculated homology features as persistence diagram
plot_persist(pers.hom)
}
