% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/te_datastore_csv.R
\name{save_to_csv}
\alias{save_to_csv}
\title{Save expanded data as CSV}
\usage{
save_to_csv(path)
}
\arguments{
\item{path}{Directory to save CSV files in. Must be empty.}
}
\value{
A \linkS4class{te_datastore_csv} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
csv_dir <- file.path(tempdir(), "expanded_trials_csv")
dir.create(csv_dir)
csv_datastore <- save_to_csv(path = csv_dir)

trial_to_expand <- trial_sequence("ITT") |>
  set_data(data = data_censored) |>
  set_expansion_options(output = csv_datastore, chunk_size = 500)

# Delete directory after use
unlink(csv_dir)

}
\seealso{
Other save_to: 
\code{\link{save_to_datatable}()},
\code{\link{save_to_duckdb}()},
\code{\link{set_expansion_options}()}
}
\concept{save_to}
