% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweedieGLMM.R
\name{tweedieGLMM}
\alias{tweedieGLMM}
\title{Fitting a Tweedie GLMM, using initial estimates from credibility models}
\usage{
tweedieGLMM(
  formula,
  data,
  weights,
  muHatGLM = FALSE,
  epsilon = 1e-04,
  maxiter = 500,
  verbose = FALSE,
  balanceProperty = TRUE
)
}
\arguments{
\item{formula}{object of type \code{\link{formula}} that specifies which model should be fitted. Syntax is the same as for
\code{\link[lme4]{lmer}} and \code{\link[lme4]{glmer}}. For single random effect: \code{Y ~ x1 + x2 + (1 | Cluster)}.
For nested random effects: \code{Y ~ x1 + x2 + (1 | cluster / subcluster)}.}

\item{data}{an object that is coercible by \code{\link[data.table]{as.data.table}}, containing the variables in the model.}

\item{weights}{variable name of the exposure weight.}

\item{muHatGLM}{indicates which estimate has to be used in the algorithm for the intercept term. Default is \code{FALSE},
which uses the intercept as estimated by the credibility model. If \code{TRUE}, the estimate of the GLM is used.}

\item{epsilon}{positive convergence tolerance \eqn{\epsilon}; the iterations converge when
\eqn{||\theta[k] - \theta[k - 1]||^2_2/||\theta[k - 1]||^2_2 < \epsilon}. Here, \eqn{\theta[k]} is the parameter vector at the \eqn{k^{th}} iteration.}

\item{maxiter}{maximum number of iterations.}

\item{verbose}{logical indicating if output should be produced during the algorithm.}

\item{balanceProperty}{logical indicating if the balance property should be satisfied.}
}
\value{
an object of class \code{cpglmm}, containing the model fit.
}
\description{
This function first estimates the random effects model using Ohlsson's GLMC algorithm (Ohlsson, 2008) and then uses
these estimates as initial estimates when fitting a Tweedie GLMM. Supports both single random effects and
nested random effects.
}
\examples{
\donttest{
# Nested random effects example
data("tweedietraindata")
fit = tweedieGLMM(y ~ x1 + (1 | cluster / subcluster), tweedietraindata, weights = wt)
fit
}
}
\references{
Campo, B.D.C. and Antonio, Katrien (2023). Insurance pricing with hierarchically structured data an illustration with a workers' compensation insurance portfolio. \emph{Scandinavian Actuarial Journal}, doi: 10.1080/03461238.2022.2161413

Ohlsson, E. (2008). Combining generalized linear models and credibility models in practice. \emph{Scandinavian Actuarial Journal} \bold{2008}(4), 301–314.
}
\seealso{
\code{\link[cplm]{cpglmm}}, \code{\link{hierCredTweedie}}
}
