% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countable_set.R
\name{countable_set}
\alias{countable_set}
\title{Countable Set}
\description{
A countably infinite support set, such as the non-negative
integers. It satisfies the concept of a support (see \code{\link{has}},
\code{\link{infimum}}, \code{\link{supremum}}, \code{\link[base]{dim}}).
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{lower_bound}}{Integer lower bound of the set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-countable_set-new}{\code{countable_set$new()}}
\item \href{#method-countable_set-clone}{\code{countable_set$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-countable_set-new"></a>}}
\if{latex}{\out{\hypertarget{method-countable_set-new}{}}}
\subsection{Method \code{new()}}{
Initialize a countable set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{countable_set$new(lower = 0L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{lower}}{Integer lower bound (default 0).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-countable_set-clone"></a>}}
\if{latex}{\out{\hypertarget{method-countable_set-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{countable_set$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
