% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limits.R
\name{delta_clt}
\alias{delta_clt}
\title{Delta Method CLT Limiting Distribution}
\usage{
delta_clt(base_dist, g, dg)
}
\arguments{
\item{base_dist}{A \code{dist} object representing the base distribution.}

\item{g}{The function to apply to the sample mean.}

\item{dg}{The derivative (univariate) or Jacobian function (multivariate)
of \code{g}. For univariate distributions, \code{dg(x)} should return
a scalar. For multivariate distributions, \code{dg(x)} should return
a matrix (the Jacobian).}
}
\value{
A \code{normal} or \code{mvn} distribution representing the
Delta Method limiting distribution.
}
\description{
Returns the limiting distribution of \eqn{\sqrt{n}(g(\bar{X}_n) - g(\mu))}
under the Delta Method. For a univariate distribution, this is
\eqn{N(0, g'(\mu)^2 \sigma^2)}. For a multivariate distribution with
Jacobian \eqn{J = Dg(\mu)}, this is \eqn{MVN(0, J \Sigma J^T)}.
}
\examples{
# Delta method: g = exp, dg = exp
x <- exponential(rate = 1)
z <- delta_clt(x, g = exp, dg = exp)
mean(z)
vcov(z)
}
