% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormal.R
\name{inv_cdf.lognormal}
\alias{inv_cdf.lognormal}
\title{Inverse CDF (quantile function) for a log-normal distribution.}
\usage{
\method{inv_cdf}{lognormal}(x, ...)
}
\arguments{
\item{x}{A \code{lognormal} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(p, lower.tail = TRUE, log.p = FALSE, ...)}
returning the quantile at probability \code{p}.
}
\description{
Returns a function that computes quantiles of the log-normal distribution.
}
\examples{
x <- lognormal(0, 1)
q <- inv_cdf(x)
q(0.5)
q(0.95)
}
