% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{marginal.mixture}
\alias{marginal.mixture}
\title{Marginal distribution of a mixture.}
\usage{
\method{marginal}{mixture}(x, indices)
}
\arguments{
\item{x}{A \code{mixture} object.}

\item{indices}{Integer vector of variable indices to keep.}
}
\value{
A \code{mixture} object with marginalized components.
}
\description{
The marginal of a mixture is itself a mixture of the component marginals
with the same mixing weights:
\eqn{p(x_I) = \sum_k w_k p_k(x_I)}.
}
\details{
Requires all components to support \code{\link{marginal}}.
}
\examples{
# Mixture of bivariate normals, extract marginal over first variable
m <- mixture(
  list(mvn(c(0, 0), diag(2)), mvn(c(3, 3), diag(2))),
  c(0.5, 0.5)
)
m1 <- marginal(m, 1)
mean(m1)
}
