% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn.R
\name{marginal.mvn}
\alias{marginal.mvn}
\title{Generic method for obtaining the marginal distribution of an \code{mvn} object
\code{x} over components \code{indices}.}
\usage{
\method{marginal}{mvn}(x, indices)
}
\arguments{
\item{x}{The \code{mvn} object.}

\item{indices}{The indices of the marginal distribution to obtain.}
}
\value{
A \code{normal} (for a single index) or \code{mvn} marginal distribution.
}
\description{
Generic method for obtaining the marginal distribution of an \code{mvn} object
\code{x} over components \code{indices}.
}
\examples{
X <- mvn(c(1, 2, 3))
# Univariate marginal
marginal(X, 1)
# Bivariate marginal
marginal(X, c(1, 3))
}
