% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{mean.mixture}
\alias{mean.mixture}
\title{Mean of a mixture distribution.}
\usage{
\method{mean}{mixture}(x, ...)
}
\arguments{
\item{x}{A \code{mixture} object.}

\item{...}{Additional arguments (not used).}
}
\value{
The mean of the mixture distribution.
}
\description{
The mean of a mixture is the weighted sum of the component means:
\eqn{E[X] = \sum_k w_k \mu_k}.
}
\examples{
m <- mixture(list(normal(0, 1), normal(10, 1)), c(0.5, 0.5))
mean(m)
}
