% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic_dist.R
\name{rmap}
\alias{rmap}
\title{Generic method for applying a map \code{f} to distribution object \code{x}.}
\usage{
rmap(x, g, ...)
}
\arguments{
\item{x}{The distribution object.}

\item{g}{The function to apply.}

\item{...}{Additional arguments to pass into \code{g}.}
}
\value{
A distribution representing the push-forward of \code{x} through \code{g}.
}
\description{
Generic method for applying a map \code{f} to distribution object \code{x}.
}
\examples{
\donttest{
d <- empirical_dist(1:20)
d_sq <- rmap(d, function(x) x^2)
mean(d_sq)  # E[X^2] for uniform 1..20
}
}
