% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{rmap.dist}
\alias{rmap.dist}
\title{Method for obtaining g(x)) where x is a \code{dist} object.}
\usage{
\method{rmap}{dist}(x, g, n = 10000L, ...)
}
\arguments{
\item{x}{The distribution object.}

\item{g}{The function to apply to the distribution.}

\item{n}{The number of samples to generate for the MC estimate of the
conditional distribution x | P. Defaults to 10000.}

\item{...}{additional arguments to pass into \code{g}.}
}
\value{
An \code{empirical_dist} of the transformed samples.
}
\description{
Falls back to MC: materializes \code{x} via \code{ensure_realized()} and
then applies \code{rmap} with \code{g} to the resulting empirical distribution.
}
\examples{
\donttest{
set.seed(1)
x <- exponential(1)
# Distribution of log(X) where X ~ Exp(1)
log_x <- rmap(x, log)
mean(log_x)
}
}
