% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edist.R
\name{rmap.edist}
\alias{rmap.edist}
\title{Map function over expression distribution.}
\usage{
\method{rmap}{edist}(x, g, ...)
}
\arguments{
\item{x}{An \code{edist} object.}

\item{g}{Function to apply to each observation.}

\item{...}{Additional arguments forwarded to \code{g}.}
}
\value{
A transformed \code{empirical_dist}.
}
\description{
Falls back to \code{\link{realize}} and delegates to
\code{\link{rmap.empirical_dist}}.
}
\examples{
\donttest{
set.seed(1)
z <- normal(0, 1) * exponential(1)
abs_z <- rmap(z, abs)
mean(abs_z)
}
}
