% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edist.R
\name{sampler.edist}
\alias{sampler.edist}
\title{Method for obtaining the sampler of an \code{edist} object.}
\usage{
\method{sampler}{edist}(x, ...)
}
\arguments{
\item{x}{The \code{edist} object to obtain the sampler of.}

\item{...}{Additional arguments to pass into each of the \code{sampler}
function generators.}
}
\value{
A function that takes a number of samples \code{n}, \code{...}
which is passed into the expression \code{x$e} and returns
the result of applying the expression \code{x$e} to the
sampled values.
}
\description{
Method for obtaining the sampler of an \code{edist} object.
}
\examples{
\donttest{
set.seed(1)
z <- normal(0, 1) * exponential(2)
s <- sampler(z)
samples <- s(100)
head(samples)
}
}
