% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uniform_dist.R
\name{uniform_dist}
\alias{uniform_dist}
\title{Construct a uniform distribution object.}
\usage{
uniform_dist(min = 0, max = 1)
}
\arguments{
\item{min}{Lower bound of the distribution (default 0).}

\item{max}{Upper bound of the distribution (default 1).}
}
\value{
A \code{uniform_dist} object with classes
\code{c("uniform_dist", "univariate_dist", "continuous_dist", "dist")}.
}
\description{
Creates an S3 object representing a continuous uniform distribution on the
interval \eqn{[min, max]}.  The PDF is \eqn{f(x) = 1/(max - min)} for
\eqn{min \le x \le max}.
}
\examples{
x <- uniform_dist(min = 0, max = 10)
mean(x)
vcov(x)
format(x)
}
