% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weibull_dist.R
\name{weibull_dist}
\alias{weibull_dist}
\title{Construct a Weibull distribution object.}
\usage{
weibull_dist(shape, scale)
}
\arguments{
\item{shape}{Positive scalar shape parameter.}

\item{scale}{Positive scalar scale parameter.}
}
\value{
A \code{weibull_dist} object with classes
\code{c("weibull_dist", "univariate_dist", "continuous_dist", "dist")}.
}
\description{
Creates an S3 object representing a Weibull distribution with the given
shape and scale parameters. The Weibull PDF is
\deqn{f(t) = (shape/scale)(t/scale)^{shape-1} \exp(-(t/scale)^{shape})}
for \eqn{t > 0}.
}
\examples{
x <- weibull_dist(shape = 2, scale = 3)
mean(x)
vcov(x)
format(x)
}
