% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_nlcd}
\alias{download_nlcd}
\title{Download land cover data}
\usage{
download_nlcd(
  product = "Land Cover",
  year = 2021,
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  unzip = TRUE,
  remove_zip = FALSE,
  hash = FALSE
)
}
\arguments{
\item{product}{character(1). "Land Cover", "Land Cover Change", "Land Cover Confidence",
"Fractional Impervious Surface", "Impervious Descriptor", or
"Spectral Change Day of Year ".}

\item{year}{integer(1). Available years for Coterminous United States range
from 1985 to 2023.}

\item{directory_to_save}{character(1). Directory to save data. Two
sub-directories will be created for the downloaded zip files ("/zip_files")
and the unzipped shapefiles ("/data_files").}

\item{acknowledgement}{logical(1). By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{unzip}{logical(1). Unzip zip files. Default is \code{TRUE}.}

\item{remove_zip}{logical(1). Remove zip files from directory_to_download.
Default is \code{FALSE}.}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item Zip and/or data files will be downloaded and stored in
respective sub-directories within \code{directory_to_save}.
}
}
\description{
The \code{download_nlcd()} function accesses and downloads
annual land cover data from the
\href{https://www.mrlc.gov/data/project/annual-nlcd}{Multi-Resolution Land Characteristics (MRLC) Consortium's National Land Cover Database (NLCD) products data base}.
}
\examples{
\dontrun{
download_nlcd(
  product = "Land Cover",
  year = 2021,
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE # NOTE: download skipped for examples
)
}
}
\references{
\insertRef{dewitz_national_2023}{amadeus}\if{html}{\out{<br/>}}
\insertRef{dewitz_national_2024}{amadeus}
}
\author{
Mitchell Manware, Insang Song
}
