% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FunctionsWeightedTrawl.R
\name{kernel_generic_trawl_acf}
\alias{kernel_generic_trawl_acf}
\title{kernel_generic_trawl_acf}
\usage{
kernel_generic_trawl_acf(p, g, x)
}
\arguments{
\item{p}{kernel function to be used in the weighted trawl process}

\item{g}{trawl function}

\item{x}{argument for which the acf will be computed (this can be a vector)}
}
\value{
acf or vector of acfs evaluated in x
}
\description{
kernel_generic_trawl_acf
}
\details{
We numerically approximate the acf for a given
periodic function p and a given trawl function g
}
\examples{
my_p <- function(x){sin(x)}
my_g <- function(x){exp(-x)}
kernel_generic_trawl_acf(my_p, my_g, 1)

kernel_generic_trawl_acf(my_p, my_g, c(1,2,3,4))
}
