% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorVariation.R
\name{colorVariation}
\alias{colorVariation}
\title{Quantitative Description of Color Variation}
\usage{
colorVariation(m, method = c("frequency", "centroid", "reference"), ref = NULL)
}
\arguments{
\item{m}{character vector of colors, described using the Munsell system e.g. \code{c('10YR 3/3', '5YR 4/6')}}

\item{method}{character, one of \code{c('frequency', 'centroid', 'reference')}, see Details}

\item{ref}{character, a reference color specified in the Munsell system when \code{method = 'reference'}}
}
\value{
numeric dE00 summary of color variation
}
\description{
This function computes several measures of "color variation", typically associated with soil colors described in the Munsell system, using the CIE2000 dE (dE00) color contrast metric. The resulting dE00 summaries map closely to color differences as perceived by "average human vision".
}
\details{
dE00 values are computed according to \code{method}:
\itemize{
\item 'frequency': relative to most frequency color in \code{m}
\item 'centroid': relative to centroid (CIELAB coordinates) of colors specified in \code{m}
\item 'reference': relative to color specified in \code{ref}
}
}
\examples{

m <- c('10YR 3/3', '10YR 4/4', '10YR 4/4', '5GY 6/8')
colorVariation(m)

}
