% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{auto_mpg}
\alias{auto_mpg}
\title{Auto MPG Data Set}
\format{
A matrix containing 398 observations and 10 attributes.
\describe{
\item{\code{mpg}}{Miles per gallon of the engine. Predictor attribute}
\item{\code{cylinders}}{Number of cylinders in the engine}
\item{\code{displacement}}{Engine displacement}
\item{\code{horsepower}}{Horsepower of the car}
\item{\code{weight}}{Weight of the car (lbs)}
\item{\code{acceleration}}{Acceleration of the car (seconds taken for 0-60mph)}
\item{\code{model_year}}{Model year of the car in the 1900s}
\item{\code{origin}}{Car origin}
\item{\code{make}}{Car manufacturer}
\item{\code{car_name}}{Name of the car}
}
}
\source{
http://archive.ics.uci.edu/ml/datasets/Auto+MPG
}
\usage{
auto_mpg
}
\description{
Data concerns city-cycle fuel consumption - revised from CMU StatLib library.
}
\examples{
data(auto_mpg)    # Lazy loading
}
\references{
Quinlan,R. (1993). Combining Instance-Based and Model-Based
Learning. In Proceedings on the Tenth International Conference of Machine
Learning, 236-243, University of Massachusetts, Amherst. Morgan Kaufmann.
}
\keyword{datasets}
