% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_comparisons.R
\name{is_between}
\alias{is_between}
\title{Check if a numeric vector is between a specified minimum and maximum value}
\usage{
is_between(x, minimum, maximum, inclusive = TRUE)
}
\arguments{
\item{x}{a numeric vector to check}

\item{minimum}{The minimum value to compare against}

\item{maximum}{The maximum value to compare against}

\item{inclusive}{should comparisons allow equality with the minimum and maximum values? (flag)}
}
\value{
A logical value indicating whether all elements of the numeric vector x are between the specified minimum and maximum values
}
\description{
This function checks if a numeric vector is between a specified minimum and maximum value. It can also optionally check if all elements of the vector must be between the thresholds or if only one element is sufficient
}
\examples{
if(interactive()){
is_between(c(2,3,4), 1, 4) # TRUE
is_between(c(2,3,4), 2, 4) # TRUE
is_between(c(2,3,1), 2, 4) # FALSE
}
}
