% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visual.R
\name{astro_angle_from_sun}
\alias{astro_angle_from_sun}
\title{Angle from the Sun}
\usage{
astro_angle_from_sun(body, time)
}
\arguments{
\item{body}{Integer code identifying the celestial body. Must not be Earth.}

\item{time}{A POSIXct date-time value indicating the observation time.}
}
\value{
A list with the following elements:
\describe{
\item{angle}{The angle in degrees between the Sun and the body as seen
from the center of the Earth.}
\item{status}{Status code from the underlying C function.}
}
}
\description{
Returns the angle between a celestial body and the Sun, as seen from the
center of the Earth. This angle helps determine how easy it is to see the
body away from the glare of the Sun.
}
\examples{
time <- as.POSIXct("2025-06-15 12:00:00", tz = "UTC")
astro_angle_from_sun(body = astro_body["MERCURY"], time = time)
}
