% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position.R
\name{astro_bary_state}
\alias{astro_bary_state}
\title{Barycentric position and velocity vectors}
\usage{
astro_bary_state(body, time)
}
\arguments{
\item{body}{Identifier of celestial body (e.g., \code{astro_body["MERCURY"]}).}

\item{time}{A POSIXct time value.}
}
\value{
A list with elements:
\describe{
\item{x}{X position in AU.}
\item{y}{Y position in AU.}
\item{z}{Z position in AU.}
\item{vx}{X velocity in AU/day.}
\item{vy}{Y velocity in AU/day.}
\item{vz}{Z velocity in AU/day.}
\item{time}{Observation time as POSIXct.}
}
}
\description{
Calculates the barycentric (solar system barycenter) position and velocity vectors
for a given celestial body at a specified time.
}
\details{
The vectors are expressed in J2000 mean equator coordinates (the mean equator of the
Earth at noon UTC on 1 January 2000).
}
\examples{
time <- as.POSIXct("2025-02-19 22:10:12", tz = "UTC")
astro_bary_state(astro_body["MARS"], time)
}
